var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var snapshotProcessorWorkerId = "js/snapshotProcessor.js";
if(typeof this.importScripts !== "undefined") {
    importScripts("simpleWorker.js");
    this.MemoryAnalyzer.SimpleWorker.initializeWorker(snapshotProcessorWorkerId);
    importScripts("builtInObjectsHelper.js");
    importScripts("heapObject.js");
    importScripts("heapObjectHelpers.js");
    importScripts("percentageProgressHelper.js");
}

var MemoryAnalyzer;
(function (MemoryAnalyzer) {
    var SnapshotProcessor = (function (_super) {
        __extends(SnapshotProcessor, _super);
        function SnapshotProcessor(startWorkerOnDemand) {
                _super.call(this, snapshotProcessorWorkerId, startWorkerOnDemand);
        }
        SnapshotProcessor.prototype.processSnapshotAsync = function (snapshotData, events) {
            this.postWork(snapshotData, events);
        };
        SnapshotProcessor.prototype.processSnapshot = function (snapshotData, workerOperations) {
            if (typeof workerOperations === "undefined") { workerOperations = {
            }; }
            if(!snapshotData) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1010"));
            }
            var source = snapshotData.data;
            var pointerSize = snapshotData.pointerSize;
            var obj;
            var prop;
            var data = {
            };
            var globalObjects = [];
            var roots = [];
            var types = {
            };
            var rootMarkups = {
            };
            var winRTs = {
            };
            var objectsCount = 0;
            var definitionRoot = builtInObjectsHelper.getBuiltInDefinitions();
            var directChildrenMap = {
            };
            var filteredChildrenObjectIds = [];
            var mainProgress = new MemoryAnalyzer.PercentageProgressHelper();
            mainProgress.onProgress = function (name, percentage) {
                if(workerOperations.progress) {
                    workerOperations.progress({
                        title: name,
                        percentage: percentage
                    });
                }
            };
            var progressOperation;
            progressOperation = mainProgress.startSubOperation("ProcessingSnapshotProgress_Preprocessing", 20);
            var preprocessResult = this.preprocessSnapshot(source, progressOperation);
            data = preprocessResult.data;
            directChildrenMap = preprocessResult.directChildrenMap;
            progressOperation = mainProgress.startSubOperation("ProcessingSnapshotProgress_BuildingGraph", 30, source.length, 5000);
            for(var objIndex = 0; objIndex < source.length; objIndex++ , progressOperation.addTick()) {
                obj = source[objIndex];
                if(!obj) {
                    continue;
                }
                objectsCount++;
                obj.retainedSize = 0;
                this.addToChildrenIdentifierList(obj, data);
                if(obj.kind === "GlobalObject") {
                    globalObjects.push(obj.objectId);
                }
                var typeName = SnapshotProcessor.getType(obj, data);
                if(typeName) {
                    obj.type = typeName;
                    this.addToTypes(obj, types);
                }
                if(obj.isRoot) {
                    roots.push(obj.objectId);
                }
                if(obj.isMarkup) {
                    rootMarkups[obj.objectId] = true;
                }
                if(obj.winrt) {
                    winRTs[obj.objectId] = true;
                }
            }
            progressOperation = mainProgress.startSubOperation("ProcessingSnapshotProgress_RetainedSize", 45);
            this.calculateRetainedSize(roots, data, objectsCount, directChildrenMap, pointerSize, progressOperation);
            mainProgress.startSubOperation("ProcessingSnapshotProgress_Postprocessing", 5);
            this.removeNonrootsFromMarkups(rootMarkups, data);
            this.removeNonrootsFromWinRTs(winRTs, data);
            var rootMarkupIds = Object.keys(rootMarkups).map(function (value) {
                return parseInt(value, 10);
            });
            var winRTIds = Object.keys(winRTs).map(function (value) {
                return parseInt(value, 10);
            });
            var payload = {
            };
            payload.pointerSize = pointerSize;
            payload.data = data;
            data = null;
            payload.graph = {
                globalObjects: globalObjects,
                roots: roots,
                count: objectsCount,
                types: types,
                rootMarkups: rootMarkupIds,
                winRTs: winRTIds
            };
            payload.filteredChildrenObjectIds = filteredChildrenObjectIds;
            mainProgress.startSubOperation("ProcessingSnapshotProgress_Serializing");
            if(workerOperations.moveData) {
                var objects = MemoryAnalyzer.HeapObjectHelpers.getHeapObjectsFromMap(payload.data);
                payload.data = null;
                workerOperations.moveData(objects);
            }
            mainProgress.startSubOperation("ProcessingSnapshotProgress_Done");
            return payload;
        };
        SnapshotProcessor.prototype.preprocessSnapshot = function (source, outerProgressOperation) {
            var data;
            var directChildrenMap;
            var filteredChildrenObjectIds = [];
            var definitionRoot = builtInObjectsHelper.getBuiltInDefinitions();
            var progressOperation;
            if(outerProgressOperation) {
                outerProgressOperation.startSubOperation(null, 5);
            }
            data = MemoryAnalyzer.HeapObjectHelpers.getHeapMap(source);
            if(outerProgressOperation) {
                outerProgressOperation.startSubOperation(null, 15);
            }
            this.processGettersAndSetters(source, data);
            if(outerProgressOperation) {
                outerProgressOperation.startSubOperation(null, 40);
            }
            directChildrenMap = MemoryAnalyzer.HeapObjectHelpers.getDirectChildrenMap(source, data, MemoryAnalyzer.DirectChildrenKind.All, filteredChildrenObjectIds);
            if(outerProgressOperation) {
                progressOperation = outerProgressOperation.startSubOperation(null, 40, source.length, 5000);
            }
            for(var objIndex = 0; objIndex < source.length; objIndex++) {
                var obj = source[objIndex];
                this.addToChildrenParents(obj, data, directChildrenMap);
                this.markBuiltInObject(definitionRoot, obj, data);
                this.setObjectValue(obj);
                if(obj.isMarkup) {
                    if(obj.elementAttributesSize) {
                        obj.size += obj.elementAttributesSize;
                    }
                    if(obj.elementTextChildrenSize) {
                        obj.size += obj.elementTextChildrenSize;
                    }
                }
                if(progressOperation) {
                    progressOperation.addTick();
                }
            }
            this.removeUnwantedItems(source, data, directChildrenMap);
            return {
                data: data,
                directChildrenMap: directChildrenMap
            };
        };
        SnapshotProcessor.prototype.processWork = function (snapshotData, workerOperations) {
            return this.processSnapshot(snapshotData, workerOperations);
        };
        SnapshotProcessor.prototype.processGettersAndSetters = function (source, data) {
            var placeHolderObjectId = 1;
            for(var objIndex = source.length - 1; objIndex >= 0; objIndex--) {
                var obj = source[objIndex];
                if(obj.properties) {
                    placeHolderObjectId = this.findGetterAndSetterProperties(source, data, obj, placeHolderObjectId);
                }
            }
        };
        SnapshotProcessor.prototype.updateGetterAndSetterProperties = function (data, prop, methodType) {
            var newPropName = methodType;
            if(prop.objectId) {
                var functionName = data[prop.objectId].functionName;
                if(functionName && functionName !== methodType) {
                    newPropName = methodType + ": " + functionName;
                }
            }
            prop.name = newPropName;
        };
        SnapshotProcessor.prototype.findGetterAndSetterProperties = function (source, data, obj, placeHolderObjectId) {
            var propertyNames = {
            };
            var seenGetterSetterProperty = false;
            for(var childIndex = obj.properties.length - 1; childIndex >= 0; childIndex--) {
                var currentProperty = obj.properties[childIndex];
                var currentPropertyName = currentProperty.name + "Property";
                if(Object.prototype.hasOwnProperty.call(propertyNames, currentPropertyName)) {
                    seenGetterSetterProperty = true;
                    var propertyName = currentProperty.name;
                    var previousPropertyIndex = propertyNames[currentPropertyName];
                    var previousProperty = obj.properties[previousPropertyIndex];
                    this.updateGetterAndSetterProperties(data, currentProperty, "get");
                    this.updateGetterAndSetterProperties(data, previousProperty, "set");
                    placeHolderObjectId = placeHolderObjectId + 1;
                    var placeholder = {
                        objectId: placeHolderObjectId,
                        kind: "Property",
                        size: 0,
                        properties: [
                            currentProperty, 
                            previousProperty
                        ]
                    };
                    var placeHolderProperty = {
                        objectId: placeHolderObjectId,
                        name: propertyName
                    };
                    obj.properties.push(placeHolderProperty);
                    obj.properties[previousPropertyIndex] = null;
                    obj.properties[childIndex] = null;
                    source.push(placeholder);
                    data[placeholder.objectId] = placeholder;
                } else {
                    propertyNames[currentPropertyName] = childIndex;
                }
            }
            if(seenGetterSetterProperty) {
                var properties = [];
                for(var childIndex = 0; childIndex < obj.properties.length; childIndex++) {
                    var child = obj.properties[childIndex];
                    if(child) {
                        properties.push(child);
                    }
                }
                obj.properties = properties;
            }
            return placeHolderObjectId;
        };
        SnapshotProcessor.prototype.setupObjectIdMap = function (source, data) {
            for(var i = 0; i < source.length; i++) {
                var object = source[i];
                data[object.objectId] = object;
            }
        };
        SnapshotProcessor.prototype.addToChildrenParents = function (obj, data, directChildrenMap) {
            var seenChild = {
            };
            var directChildren = directChildrenMap[obj.objectId];
            for(var i = 0; i < directChildren.length; i++) {
                var childProp = directChildren[i];
                var childObj = data[childProp.objectId];
                if(childObj) {
                    if(seenChild[childObj.objectId]) {
                        continue;
                    }
                    if(!childObj.parents) {
                        childObj.parents = [];
                    }
                    childObj.parents.push(obj.objectId);
                    seenChild[childObj.objectId] = true;
                }
            }
        };
        SnapshotProcessor.prototype.addToChildrenIdentifierList = function (obj, data) {
            for(var propKey in obj.properties) {
                var prop = obj.properties[propKey];
                if(prop.name) {
                    var propObj = data[prop.objectId];
                    if(propObj) {
                        if(!propObj.identifierList) {
                            propObj.identifierList = [];
                        }
                        if(propObj.identifierList.indexOf(prop.name) == -1) {
                            propObj.identifierList.push(prop.name);
                        }
                    }
                }
            }
        };
        SnapshotProcessor.prototype.removeUnwantedItems = function (source, data, directChildrenMap) {
            var roots = [];
            var objectIdsToRemove = {
            };
            for(var i = 0; i < source.length; i++) {
                var obj = source[i];
                if(obj.isRoot) {
                    roots.push(obj.objectId);
                }
                if(obj.kind === "Window") {
                    var hasGlobalObjectParent = false;
                    if(obj.parents) {
                        for(var parentIndex = 0; parentIndex < obj.parents.length; parentIndex++) {
                            var parentId = obj.parents[parentIndex];
                            var parent = data[parentId];
                            if(parent && parent.kind === "GlobalObject") {
                                hasGlobalObjectParent = true;
                                break;
                            }
                        }
                    }
                    if(!hasGlobalObjectParent) {
                        objectIdsToRemove[obj.objectId] = true;
                    }
                } else {
                    if(obj.kind === "GlobalObject") {
                        if(obj.properties) {
                            var properties = obj.properties;
                            var propertiesLength = properties.length;
                            for(var propIndex = propertiesLength - 1; propIndex >= 0; propIndex--) {
                                var prop = properties[propIndex];
                                var propName = prop.name;
                                if(propName && propName.slice(0, "__VISUALSTUDIO".length) === "__VISUALSTUDIO") {
                                    properties.splice(propIndex, 1);
                                    this.removePropertyFromDirectChildren(directChildrenMap[obj.objectId], prop);
                                }
                            }
                        }
                    } else {
                        if(obj.external === 3) {
                            objectIdsToRemove[obj.objectId] = true;
                        }
                    }
                }
            }
            var removedCount = this.removeAllObjects(objectIdsToRemove, source, data, roots, directChildrenMap);
            return removedCount;
        };
        SnapshotProcessor.prototype.removeAllObjects = function (objectIdsToRemove, source, data, roots, directChildrenMap) {
            var removedCount = 0;
            if(Object.getOwnPropertyNames(objectIdsToRemove).length == 0) {
                return removedCount;
            }
            var markedObjects = {
            };
            for(var rootIndex = 0; rootIndex < roots.length; rootIndex++) {
                this.markObjects(roots[rootIndex], objectIdsToRemove, directChildrenMap, markedObjects);
            }
            for(var i = 0; i < source.length; i++) {
                var obj = source[i];
                if(markedObjects[obj.objectId]) {
                    continue;
                }
                if(obj.parents) {
                    for(var parentIndex = 0; parentIndex < obj.parents.length; parentIndex++) {
                        var parentId = obj.parents[parentIndex];
                        if(markedObjects[parentId]) {
                            var parentObj = data[parentId];
                            if(parentObj) {
                                MemoryAnalyzer.HeapObjectHelpers.removeChildEntry(parentObj, obj.objectId);
                                this.removeObjectIdFromDirectChildren(directChildrenMap[parentId], obj.objectId);
                            }
                        }
                    }
                }
                var directChildren = directChildrenMap[obj.objectId];
                if(directChildren) {
                    for(var childIndex = 0; childIndex < directChildren.length; childIndex++) {
                        var childObjectId = directChildren[childIndex].objectId;
                        if(markedObjects[childObjectId]) {
                            var childObj = data[childObjectId];
                            if(childObj) {
                                MemoryAnalyzer.HeapObjectHelpers.removeParentEntry(childObj, obj.objectId);
                            }
                        }
                    }
                }
                delete data[obj.objectId];
                source[i] = null;
                removedCount++;
            }
            return removedCount;
        };
        SnapshotProcessor.prototype.markObjects = function (objectId, execludeObjectIds, directChildrenMap, markResult) {
            if(execludeObjectIds[objectId] || markResult[objectId]) {
                return;
            }
            markResult[objectId] = true;
            var directChildren = directChildrenMap[objectId];
            for(var i = 0; i < directChildren.length; i++) {
                var childObjectId = directChildren[i].objectId;
                if(childObjectId) {
                    this.markObjects(childObjectId, execludeObjectIds, directChildrenMap, markResult);
                }
            }
        };
        SnapshotProcessor.prototype.removePropertyFromDirectChildren = function (directChildrenList, prop) {
            if(directChildrenList) {
                for(var i = 0; i < directChildrenList.length; i++) {
                    if(directChildrenList[i] === prop) {
                        directChildrenList.splice(i, 1);
                        break;
                    }
                }
            }
        };
        SnapshotProcessor.prototype.removeObjectIdFromDirectChildren = function (directChildrenList, objectId) {
            if(directChildrenList) {
                var listLength = directChildrenList.length;
                for(var i = listLength - 1; i >= 0; i--) {
                    if(directChildrenList[i].objectId === objectId) {
                        directChildrenList.splice(i, 1);
                    }
                }
            }
        };
        SnapshotProcessor.prototype.calculateRetainedSize = function (roots, data, objectsCount, directChildrenMap, pointerSize, outterProgressOperation) {
            var progressOperation;
            var mainRoot = {
                objectId: 0,
                size: 0,
                properties: []
            };
            for(var i = 0; i < roots.length; i++) {
                var rootId = roots[i];
                var rootObj = data[rootId];
                if(rootObj.external) {
                    continue;
                }
                var rootProp = {
                    name: "root" + i,
                    objectId: rootId
                };
                mainRoot.properties.push(rootProp);
                rootObj.parents = [
                    mainRoot.objectId
                ];
            }
            directChildrenMap[mainRoot.objectId] = mainRoot.properties;
            data[mainRoot.objectId] = mainRoot;
            var ancestorsMap = {
            };
            ancestorsMap[mainRoot.objectId] = [
                mainRoot.objectId
            ];
            var visited = {
            };
            visited[mainRoot.objectId] = true;
            var objectIdsByDepth = [];
            if(outterProgressOperation) {
                progressOperation = outterProgressOperation.startSubOperation(null, 70, objectsCount, 5000);
            }
            var queue = [
                mainRoot.objectId
            ];
            while(queue.length > 0) {
                var currentId = queue.shift();
                var currentObj = data[currentId];
                currentObj.retainedSize = currentObj.size;
                var directChildren = directChildrenMap[currentId];
                for(var i = 0; i < directChildren.length; i++) {
                    var child = directChildren[i];
                    var childId = child.objectId;
                    if(typeof childId !== "undefined") {
                        if(!visited[childId]) {
                            visited[childId] = true;
                            queue.push(childId);
                            ancestorsMap[childId] = ancestorsMap[currentId].slice(0);
                            ancestorsMap[childId].push(childId);
                        } else {
                            if(ancestorsMap[childId].length === ancestorsMap[currentId].length + 1) {
                                for(var j = ancestorsMap[currentId].length - 1; j >= 0; j--) {
                                    if(ancestorsMap[currentId][j] !== ancestorsMap[childId][j]) {
                                        ancestorsMap[childId][j] = null;
                                    }
                                }
                            }
                        }
                    } else {
                        if(typeof child.stringValue !== "undefined") {
                            currentObj.retainedSize += MemoryAnalyzer.HeapObjectHelpers.getValuePropSize(child, pointerSize);
                        }
                    }
                }
                objectIdsByDepth.push(currentId);
                if(progressOperation) {
                    progressOperation.addTick();
                }
            }
            if(outterProgressOperation) {
                progressOperation = outterProgressOperation.startSubOperation(null, 30, objectsCount, 5000);
            }
            var depthNodeIndex = objectIdsByDepth.length - 1;
            while(depthNodeIndex > 0) {
                var obj = data[objectIdsByDepth[depthNodeIndex]];
                if(obj.parents.length === 1) {
                    data[obj.parents[0]].retainedSize += obj.retainedSize;
                } else {
                    var nearestCommonAncestorId = this.findNearestCommonAncestor(obj.parents, data, directChildrenMap, ancestorsMap);
                    data[nearestCommonAncestorId].retainedSize += obj.retainedSize;
                }
                depthNodeIndex--;
                if(progressOperation) {
                    progressOperation.addTick();
                }
            }
            delete data[mainRoot.objectId];
            delete directChildrenMap[mainRoot.objectId];
            for(var i = 0; i < roots.length; i++) {
                delete data[roots[i]].parents;
            }
        };
        SnapshotProcessor.prototype.findNearestCommonAncestor = function (objectIds, data, directChildrenMap, ancestorsMap) {
            var nearestCommonAncestor = objectIds.reduce(function (previous, current) {
                if(!ancestorsMap[previous]) {
                    return current;
                }
                if(!ancestorsMap[current]) {
                    return previous;
                }
                var depth1 = ancestorsMap[previous].length - 1;
                var depth2 = ancestorsMap[current].length - 1;
                var index = Math.min(depth1, depth2);
                while(index >= 0) {
                    var common = ancestorsMap[previous][index];
                    if(common === ancestorsMap[current][index] && common !== null && ancestorsMap[current][index] !== null) {
                        return common;
                    }
                    index--;
                }
                return null;
            });
            return nearestCommonAncestor;
        };
        SnapshotProcessor.prototype.addToTypes = function (obj, types) {
            var typeName = obj.type;
            var type = types[typeName];
            if(!types.hasOwnProperty(typeName)) {
                type = {
                    size: 0,
                    objectIds: []
                };
                types[typeName] = type;
            }
            if(obj.size) {
                type.size += obj.size;
            }
            type.objectIds.push(obj.objectId);
        };
        SnapshotProcessor.getType = function getType(obj, data) {
            var j;
            var prop;
            if(obj.kind === "GlobalObject") {
                return SnapshotProcessor.simplifyObjectKind(obj.kind);
            }
            if(obj.kind === "Scope") {
                return obj.kind;
            }
            if(obj.winrt) {
                return obj.kind;
            }
            if(obj.external) {
                if(obj.kind) {
                    return obj.kind;
                } else {
                    return "Unknown";
                }
            }
            var heapTypePropertyName = "_heapobject_type_";
            if(obj.properties) {
                for(j = 0; j < obj.properties.length; j++) {
                    prop = obj.properties[j];
                    if(prop.name && prop.name.length > heapTypePropertyName.length && prop.name.substring(0, heapTypePropertyName.length) === heapTypePropertyName) {
                        return prop.name.substring(heapTypePropertyName.length);
                    }
                }
            }
            var currentObject = obj;
            while(currentObject) {
                if(currentObject.properties) {
                    for(j = 0; j < currentObject.properties.length; j++) {
                        prop = currentObject.properties[j];
                        if(prop.name === "constructor") {
                            var ctorObject = data[prop.objectId];
                            if(ctorObject && ctorObject.functionName) {
                                return ctorObject.functionName;
                            }
                        }
                    }
                }
                if(currentObject.prototype) {
                    currentObject = data[currentObject.prototype];
                } else {
                    break;
                }
            }
            if(obj.kind === "ObjectObject") {
                if(obj.prototype) {
                    var protoObj = data[obj.prototype];
                    if(protoObj && protoObj.kind === "Null") {
                        return SnapshotProcessor.simplifyObjectKind(obj.kind);
                    }
                }
            } else {
                if(obj.kind) {
                    return SnapshotProcessor.simplifyObjectKind(obj.kind);
                }
            }
            if(obj.properties) {
                var typeName = "";
                for(j = 0; j < obj.properties.length; j++) {
                    prop = obj.properties[j];
                    if(prop.name && !SnapshotProcessor.isPropertyNameBuiltIn(prop.name)) {
                        typeName += prop.name;
                        if(j + 1 < obj.properties.length) {
                            typeName += ", ";
                        }
                    }
                }
                if(typeName.length > 0) {
                    return "{ " + typeName + " }";
                }
            }
            if(obj.kind) {
                return SnapshotProcessor.simplifyObjectKind(obj.kind);
            }
            return "Unknown";
        }
        SnapshotProcessor.simplifyObjectKind = function simplifyObjectKind(kind) {
            switch(kind) {
                case "ObjectObject": {
                    return "Object";

                }
                case "GlobalObject": {
                    return "Global";

                }
                case "BooleanObject": {
                    return "Boolean";

                }
                case "DateObject": {
                    return "Date";

                }
                case "FunctionObject": {
                    return "Function";

                }
                case "NumberObject": {
                    return "Number";

                }
                case "RegexObject": {
                    return "RegExp";

                }
                case "StringObject": {
                    return "String";

                }
                case "TypedArrayObject": {
                    return "TypedArray";

                }
                case "ArrayObject": {
                    return "Array";

                }
                case "ArgumentObject": {
                    return "Arguments";

                }
                default: {
                    return kind;

                }
            }
        }
        SnapshotProcessor.prototype.removeNonrootsFromMarkups = function (rootMarkups, data) {
            var objectIds = Object.keys(rootMarkups);
            for(var i = 0; i < objectIds.length; i++) {
                var objectId = objectIds[i];
                var obj = data[objectId];
                if(obj) {
                    for(var relationKey in obj.relationships) {
                        var relation = obj.relationships[relationKey];
                        if(relation.objectId) {
                            delete rootMarkups[relation.objectId];
                        }
                    }
                }
            }
        };
        SnapshotProcessor.prototype.removeNonrootsFromWinRTs = function (winRTs, data) {
            var objectIds = Object.keys(winRTs);
            for(var i = 0; i < objectIds.length; i++) {
                var objectId = objectIds[i];
                var obj = data[objectId];
                if(obj) {
                    for(var propKey in obj.properties) {
                        var prop = obj.properties[propKey];
                        if(prop.objectId) {
                            delete winRTs[prop.objectId];
                        }
                    }
                }
            }
        };
        SnapshotProcessor.prototype.markBuiltInObject = function (definitionRoot, obj, memoryMap) {
            this.markBuiltInObjectRecursive(definitionRoot, null, obj, memoryMap, {
            });
        };
        SnapshotProcessor.prototype.markBuiltInObjectRecursive = function (definitionRoot, prop, obj, memoryMap, visitedIds) {
            if(!definitionRoot) {
                return false;
            }
            var propName;
            if(prop) {
                propName = prop.name;
            }
            if(!definitionRoot.isRecursive) {
                var definitionPropertyName = builtInObjectsHelper.getDefinitionPropertyName(propName, obj);
                if(!definitionRoot.hasOwnProperty(definitionPropertyName)) {
                    return false;
                }
            }
            if(typeof obj.isBuiltIn !== "undefined") {
                return obj.isBuiltIn;
            }
            if(obj.objectId && visitedIds[obj.objectId]) {
                return true;
            }
            var isMatchedPrototypeChain = true;
            var isBuiltIn = true;
            var definition = definitionRoot.isRecursive ? definitionRoot : definitionRoot[definitionPropertyName];
            if(obj.objectId) {
                visitedIds[obj.objectId] = true;
            }
            if(definition && definition.hasPrototype) {
                var prototypeObject = memoryMap[obj.prototype];
                if(prototypeObject) {
                    if(!this.markBuiltInObjectRecursive(definition, {
                        name: "$prototype"
                    }, prototypeObject, memoryMap, visitedIds)) {
                        isMatchedPrototypeChain = false;
                    }
                } else {
                    isMatchedPrototypeChain = false;
                }
            }
            if(isMatchedPrototypeChain) {
                if(obj.properties) {
                    var propsLength = obj.properties.length;
                    for(var i = 0; i < propsLength; i++) {
                        var childProp = obj.properties[i];
                        if(childProp.objectId) {
                            var propertyObject = memoryMap[childProp.objectId];
                            if(propertyObject) {
                                if(!this.markBuiltInObjectRecursive(definition, childProp, propertyObject, memoryMap, visitedIds)) {
                                    isBuiltIn = false;
                                }
                            }
                        } else {
                            if(typeof childProp.numberValue !== "undefined") {
                                var propertyObject = {
                                    kind: "NUMBER"
                                };
                                if(!this.markBuiltInObjectRecursive(definition, childProp, propertyObject, memoryMap, visitedIds)) {
                                    isBuiltIn = false;
                                }
                            }
                        }
                    }
                }
                if(obj.kind === "Boolean") {
                    if(prop) {
                        (prop).isBuiltIn = isBuiltIn;
                    }
                } else {
                    obj.isBuiltIn = isBuiltIn;
                }
            }
            visitedIds[obj.objectId] = false;
            return isMatchedPrototypeChain && isBuiltIn;
        };
        SnapshotProcessor.prototype.setObjectValue = function (obj) {
            if(typeof obj.internalProperties !== "undefined" && obj.internalProperties) {
                var i = 0;
                while(i < obj.internalProperties.length) {
                    var prop = obj.internalProperties[i];
                    if(prop.stringValue) {
                        obj.value = prop.stringValue;
                        var size = obj.size;
                        if(!size) {
                            size = 0;
                        }
                        obj.size = size + prop.stringValue.length * 2;
                        obj.internalProperties.splice(i, 1);
                        continue;
                    }
                    ++i;
                }
                if(obj.internalProperties.length === 0) {
                    delete obj.internalProperties;
                }
            }
        };
        SnapshotProcessor.isPropertyNameBuiltIn = function isPropertyNameBuiltIn(name) {
            if(!name) {
                return false;
            }
            if(name === "prototype" || name === "constructor") {
                return true;
            } else {
                return false;
            }
        }
        return SnapshotProcessor;
    })(MemoryAnalyzer.SimpleWorker);
    MemoryAnalyzer.SnapshotProcessor = SnapshotProcessor;    
})(MemoryAnalyzer || (MemoryAnalyzer = {}));
if(this.MemoryAnalyzer.SimpleWorker.isInsideWorker(snapshotProcessorWorkerId)) {
    var snapshotProcessor = new this.MemoryAnalyzer.SnapshotProcessor();
}
//@ sourceMappingURL=snapshotProcessor.js.map

// SIG // Begin signature block
// SIG // MIIanwYJKoZIhvcNAQcCoIIakDCCGowCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFCIMeWq/MkbG
// SIG // ETnvm2Nlmw2sQ+gnoIIVeTCCBLowggOioAMCAQICCmEC
// SIG // jkIAAAAAAB8wDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OFoXDTEz
// SIG // MDQwOTIyMjU1OFowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpGNTI4LTM3NzctOEE3NjElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJbsjkdN
// SIG // VMJclYDXTgs9v5dDw0vjYGcRLwFNDNjRRi8QQN4LpFBS
// SIG // EogLQ3otP+5IbmbHkeYDym7sealqI5vNYp7NaqQ/56ND
// SIG // /2JHobS6RPrfQMGFVH7ooKcsQyObUh8yNfT+mlafjWN3
// SIG // ezCeCjOFchvKSsjMJc3bXREux7CM8Y9DSEcFtXogC+Xz
// SIG // 78G69LPYzTiP+yGqPQpthRfQyueGA8Azg7UlxMxanMTD
// SIG // 2mIlTVMlFGGP+xvg7PdHxoBF5jVTIzZ3yrDdmCs5wHU1
// SIG // D92BTCE9djDFsrBlcylIJ9jC0rCER7t4utV0A97XSxn3
// SIG // U9542ob3YYgmM7RHxqBUiBUrLHUCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBQv6EbIaNNuT7Ig0N6JTvFH7kjB8jAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBz/30unc2NiCt8feNeFXHp
// SIG // aGLwCLZDVsRcSi1o2PlIEZHzEZyF7BLUVKB1qTihWX91
// SIG // 7sb1NNhUpOLQzHyXq5N1MJcHHQRTLDZ/f/FAHgybgOIS
// SIG // CiA6McAHdWfg+jSc7Ij7VxzlWGIgkEUvXUWpyI6zfHJt
// SIG // ECfFS9hvoqgSs201I2f6LNslLbldsR4F50MoPpwFdnfx
// SIG // Jd4FRxlt3kmFodpKSwhGITWodTZMt7MIqt+3K9m+Kmr9
// SIG // 3zUXzD8Mx90Gz06UJGMgCy4krl9DRBJ6XN0326RFs5E6
// SIG // Eld940fGZtPPnEZW9EwHseAMqtX21Tyi4LXU+Bx+BFUQ
// SIG // axj0kc1Rp5VlMIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSSMIIEjgIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIG0MBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBQz4GVybDk9J8HtLOf/SWR8
// SIG // Pysa2TBUBgorBgEEAYI3AgEMMUYwRKAqgCgAcwBuAGEA
// SIG // cABzAGgAbwB0AFAAcgBvAGMAZQBzAHMAbwByAC4AagBz
// SIG // oRaAFGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3
// SIG // DQEBAQUABIIBAL2fNxUpTRMnfwoI16UAMVSiPNKNKu52
// SIG // WT/sTKdWgxEyZb/C9E4rhS15A/EkdCRtVBJrzO4WSijj
// SIG // v0rLaNuXHIBTMOBx50fzz/58qb1UqFtE9q0mhlW9SZVG
// SIG // EQPC6LFRUe1sLe+SY+VngHJnDLkFTgooxBJovCKXCn/O
// SIG // ua3fQOEsG823vRyAhUkCR6DyLJCC/7y7vLCf20kLQt56
// SIG // l33nqW1RTiTp0ZAzWsHdVLmUx67pDUN7dTZEUdyZt3v8
// SIG // C7YLHw80TXjKI802zXhLIBm0a6bWQr9XNBrRoKRC6lyl
// SIG // p/c+e833gbwwKRLQHNSnPkxY2IaNZyPUHlguJhOkpN9p
// SIG // 7zWhggIfMIICGwYJKoZIhvcNAQkGMYICDDCCAggCAQEw
// SIG // gYUwdzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMY
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBAgphAo5CAAAA
// SIG // AAAfMAkGBSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJ
// SIG // KoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0xMzAzMTUw
// SIG // NjMzNTlaMCMGCSqGSIb3DQEJBDEWBBRvK19qYi8Gtb7o
// SIG // EN7VS+A5IoJGlzANBgkqhkiG9w0BAQUFAASCAQAqgA+D
// SIG // kiZ5TNaM62gf/RREO38aSCj8smxEabQjb8SeMBh7+r6V
// SIG // dPnYMPgv8jqPZ/fs1cDs2kyXvmuYhoUofal7ykqLvt6V
// SIG // PgH3p9Kvrfr5zr/SkD0M35Yzk+D4GmSubG57n6c8Ejns
// SIG // caVVo4oJsl71fdCM3ZO7ahHzCzm1+cSYs6XpP/3LKMgq
// SIG // szkID9wvOik76nSelQUeqUBLe97dYs2yBYH9HnAjGY8T
// SIG // OAiOBUMu9PVa+Vk0wPFuh4ySHCHIz0TgfO+F6ONS1OH1
// SIG // cQ0ADJWqR6IFnjDAakk0zt1+3UmhAVVpoQI6BXA4wKWH
// SIG // 24BmTH/6mlUJddYomJXjf0+UjcAu
// SIG // End signature block
